

-- Table: public.tip_uplate
DROP TABLE IF EXISTS public.rezultat_ispita;
DROP TABLE IF EXISTS public.datum;
DROP TABLE IF EXISTS public.poslednja_izmena;
DROP TABLE IF EXISTS public.predmet;
DROP TABLE IF EXISTS public.rok;
DROP TABLE IF EXISTS public.skolska_godina;
DROP TABLE IF EXISTS public.tip_prijave;
DROP TABLE IF EXISTS public.tip_rezultata_ispita;


-- SEQUENCE: public.datum_id_seq

DROP SEQUENCE IF EXISTS public.datum_id_seq;

CREATE SEQUENCE public.datum_id_seq;

ALTER SEQUENCE public.datum_id_seq
    OWNER TO postgres;



-- Table: public.datum


CREATE TABLE public.datum
(
    id integer NOT NULL DEFAULT nextval('datum_id_seq'::regclass),
    datum_vreme date NOT NULL,
    CONSTRAINT datum_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.datum
    OWNER to postgres;

-- Table: public.poslednja_izmena


CREATE TABLE public.poslednja_izmena
(
    id integer NOT NULL,
    datum timestamp(4) without time zone,
    CONSTRAINT poslednje_punjenje_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.poslednja_izmena
    OWNER to postgres;

-- Table: public.predmet


CREATE TABLE public.predmet
(
    id integer NOT NULL,
    naziv character varying COLLATE pg_catalog."default",
    akronim character varying COLLATE pg_catalog."default",
    CONSTRAINT predmet_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.predmet
    OWNER to postgres;


-- Table: public.skolska_godina


CREATE TABLE public.skolska_godina
(
    id integer NOT NULL,
    naziv character varying(60) COLLATE pg_catalog."default" NOT NULL,
    CONSTRAINT skolska_godina_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.skolska_godina
    OWNER to postgres;


-- Table: public.rok


CREATE TABLE public.rok
(
    id integer NOT NULL,
    naziv character varying COLLATE pg_catalog."default",
    id_skolska_godina integer,
    CONSTRAINT rok_pkey PRIMARY KEY (id),
    CONSTRAINT id_skolska_godina_fk FOREIGN KEY (id_skolska_godina)
        REFERENCES public.skolska_godina (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.rok
    OWNER to postgres;

-- Table: public.tip_prijave


CREATE TABLE public.tip_prijave
(
    id integer NOT NULL,
    naziv character varying COLLATE pg_catalog."default",
    CONSTRAINT tip_prijave_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.tip_prijave
    OWNER to postgres;

-- Table: public.tip_rezultata_ispita


CREATE TABLE public.tip_rezultata_ispita
(
    id integer NOT NULL,
    f_polozen character varying COLLATE pg_catalog."default",
    CONSTRAINT tip_rezultata_ispita_pkey PRIMARY KEY (id)
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.tip_rezultata_ispita
    OWNER to postgres;

-- Table: public.rezultat_ispita


CREATE TABLE public.rezultat_ispita
(
    id integer NOT NULL,
    id_predmet integer,
    id_tip_prijave integer,
    ocena numeric(10,0),
    id_tip_rezultata_ispita integer,
    id_datum integer,
    id_rok integer,
    CONSTRAINT rezultat_ispita_pkey PRIMARY KEY (id),
    CONSTRAINT id_datum_fk FOREIGN KEY (id_datum)
        REFERENCES public.datum (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION,
    CONSTRAINT id_predmet_fk FOREIGN KEY (id_predmet)
        REFERENCES public.predmet (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION,
    CONSTRAINT id_rok_fk FOREIGN KEY (id_rok)
        REFERENCES public.rok (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION,
    CONSTRAINT id_tip_prijave_fk FOREIGN KEY (id_tip_prijave)
        REFERENCES public.tip_prijave (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION,
    CONSTRAINT tip_rezultata_ispita_fk FOREIGN KEY (id_tip_rezultata_ispita)
        REFERENCES public.tip_rezultata_ispita (id) MATCH SIMPLE
        ON UPDATE NO ACTION
        ON DELETE NO ACTION
)
WITH (
    OIDS = FALSE
)
TABLESPACE pg_default;

ALTER TABLE public.rezultat_ispita
    OWNER to postgres;